<?php
require_once("header.php");
require_once("menu.php");
$_SESSION['error_msg'] = "";


if(isset($_POST['submit']))
{
    $password = addslashes($_POST['password']);
    $new_password = addslashes($_POST['new_password']);
    $con_password = addslashes($_POST['con_password']);

    $uppercase = preg_match('@[A-Z]@', $new_password);
    $lowercase = preg_match('@[a-z]@', $new_password);
    $number    = preg_match('@[0-9]@', $new_password);
    $spec_char = preg_match("#\W+#", $new_password);

    if(trim($new_password) != trim($con_password))
    {
        $_SESSION['error_msg'] = "Password not match...";
    }
    elseif(trim($new_password) == $password)
    {
        $_SESSION['error_msg'] = 'New password should be different from current password';
    }
    elseif(!$uppercase || !$lowercase || !$number || !$spec_char || strlen($new_password) < 8)
    {
        $_SESSION['error_msg'] = "Must be a minimum of 8 characters,
        <br/>Must contain at least 1 number,
        <br/>Must contain at least one uppercase character,
        <br/>Must contain at least one lowercase character,
        <br/>Must contain at least one Special Symbol";
        
    }
    else
    {
        $user_id =  $_SESSION['login_id'];
        $ex = $obj->check_password($user_id,$password);
        if(mysqli_num_rows($ex) > 0)
        {
            $ex = $obj->change_password($user_id,$new_password);
            if($ex)
            {
                echo '<script>window.location="dashboard.php"</script>';
            }
            else
            {
                $_SESSION['error_msg'] = "Error...";
            }
        }
        else
        {
            $_SESSION['error_msg'] = "Current Password Invalid...";
        }

        
    }
}
?>

<div id="layoutSidenav_content">
<main class="mt-4">
    <div class="container-fluid">
        <div class="col-sm-6 col-md-6">
        <div class="card mb-4">
            <div class="card-header">
                <i class="fas fa-check-square mr-1"></i>Change Password
                <a href="dashboard.php" class="btn btn-primary btn-sm float-right">Back</a>
            </div>
            <div class="card-body">
                <form method="post">
                    <p class="text-danger"><?php echo $_SESSION['error_msg'];?></p>
                    <div class="form-group">
                        <label>Current Password</label>
                        <input type="text" class="form-control" name="password" required value="<?php echo $password;?>">
                    </div>
                    <div class="form-group">
                        <label>New Password</label>
                        <input type="text" class="form-control"  name="new_password" required value="<?php echo $new_password;?>">
                    </div>
                    <div class="form-group">
                        <label>Confirm Password</label>
                        <input type="text" class="form-control" name="con_password" required value="<?php echo $con_password;?>">
                    </div>
                    
                    <button type="submit" class="btn btn-primary" name="submit">Change Password</button>
                </form> 
            </div>
        </div>
    </div>
    </div>
</main>


<?php require_once("footer.php");?>
